<?php

session_start();

include('db.php'); 
if (!isset($_SESSION['user']) || !isset($_SESSION['user']['user_id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.',
        'cart_count' => 0
    ]);
    exit;
}

$user_id = intval($_SESSION['user']['user_id']);
$input = file_get_contents('php://input');
$data = json_decode($input, true);

$product_id = $data['product_id'] ?? null;

if (!$product_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product ID is required.'
    ]);
    exit;
}

$query_check = "
    SELECT Quantity 
    FROM cart 
    WHERE User_id = '$user_id' AND Product_id = '$product_id' AND Delete_status = 0
";
$result_check = mysqli_query($conn, $query_check);

if (mysqli_num_rows($result_check) > 0) {
    $query_update = "
        UPDATE cart 
        SET Quantity = Quantity - 1 
        WHERE User_id = '$user_id' AND Product_id = '$product_id' AND Delete_status = 0
    ";

    if (mysqli_query($conn, $query_update)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Quantity updated successfully.'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to update quantity.'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Product not found in the cart.'
    ]);
}

mysqli_close($conn);
?>
